'==========================================================================

' NAME: AnswerFileWriter.vbs
'
'***********************************************************************
' THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
' PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
' EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
' WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
' AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
' 
' Copyright (c) Microsoft Corporation.  All rights reserved.
'***********************************************************************
'
'==========================================================================
'This script file is used for reading from a supplied unattended
'answer file, then writing out a new one, based on input supplied.

'Declare File I/O Constants
Const ForReading = 1
Const ForWriting = 2
Const ForAppending = 8

Public Function CreateAnswerFile(strNewFile,strOldFile,arrOptions)
'==========================================================================
'	Name: CreateAnswerFile
'	In: strNewFile - the path and name of the new answer file
'		strOldFile - Path of master answer file to copy
'	Out: COmpletion message
'	Comment: This function creates a new answer file based on input
'			from the calling functions
'============================================================================
	'Declare Variables
	Dim arrAnswers
	Dim oTempFile
	'Read the master answer file and return array
	arrAnswers = ReadAnswerFile(strOldFile)
	
	Dim oFSO
	Set oFSO = CreateObject("Scripting.FileSystemObject")
	'Create a new file for writing
	Set oTempFile = oFSO.OpenTextFile(strNewFile,ForWriting,true)
	Set OpenForReading = oTempFile
	'Walk through the array
	For i = 0 To UBound(arrAnswers)-1
		'Evaluate
		'Since the master file we are using has 55 lines we are going to 
		'keep intact, we ignore them
		If i <=54 Then
			oTempFile.WriteLine arrAnswers(i)
		Else
			oTempFile.WriteLine arrOptions(i-55)
		End If
	Next
	oTempFile.close
	CreateAnswerFile = "Created " & strNewFile & " for IIS unattended install."
End Function

Function ReadAnswerFile(strFileName)
'==========================================================================
'	Name: ReadAnswerFile
'	In: strFileName - string constant with the full path for a text file to read
'	Out: Array holding each line of the file.
'	Comment: This function is used to read the entire content of an
'			unattended setup answer file and return it in the form of
'			an Array
'============================================================================
	'Declare Variables
	Dim oRead
	Dim strContents
	Dim arrAnswerFile

	Dim oFSO
	Set oFSO = CreateObject("Scripting.FileSystemObject")
	'Open the file using the FileSystemObject
	Set oRead = oFSO.OpenTextFile(strFileName)
	'Read the contents into a string variable
	strContents = oRead.ReadAll
	'Split the contents into array elements based on line feeds
	arrAnswerFile = Split(strContents,VbCrLf)
	'Get rid of the text file obejct
	Set oRead = Nothing
	'return the array
	ReadAnswerFile = arrAnswerFile

End Function



